package cipher

type Caesar struct {
	alphabet  []rune
	substitut []rune
}

func New(verschiebefaktor int) Caesar {
	var newCaesar Caesar

	newCaesar.alphabet = make([]rune, 52)
	newCaesar.substitut = make([]rune, 52)

	for i := 0; i < 26; i++ {
		newCaesar.alphabet[i] = 'A' + rune(i)
		newCaesar.alphabet[i+26] = 'a' + rune(i)
	}

	for i := 0; i < 26; i++ {
		if i+verschiebefaktor < 26 {
			newCaesar.substitut[i] = newCaesar.alphabet[i+verschiebefaktor]
			newCaesar.substitut[i+26] = newCaesar.alphabet[i+26+verschiebefaktor]
		} else {
			newCaesar.substitut[i] = newCaesar.alphabet[i+verschiebefaktor-26]
			newCaesar.substitut[i+26] = newCaesar.alphabet[i+26+verschiebefaktor-26]
		}
	}
	return newCaesar
}
