package main

import (
	"fmt"
	"log"
	"os"
)

func dirtree(dirname, pad string) {
	listing, err := os.ReadDir(dirname)
	if err != nil {
		log.Fatalln(err)
	}
	for _, entry := range listing {
		if entry.IsDir() {
			fmt.Println(pad + entry.Name() + "/")
			dirtree(dirname+"/"+entry.Name(), pad+"  ")
		} else {
			fmt.Println(pad + entry.Name())
		}
	}
}

func main() {
	dirtree(os.Args[1], "")
}
