package main

import (
	"fmt"
	"log"
	"strings"
)

const filename = "persons.csv"

type Person struct {
	Vorname, Nachname, Email string
}

func inputPerson(person *Person) {

	fmt.Print("Vorname>")
	fmt.Scanln(&person.Vorname)
	fmt.Print("Nachname>")
	fmt.Scanln(&person.Nachname)
	fmt.Print("Email>")
	fmt.Scanln(&person.Email)
}

func main() {
	var personen []Person

	for {
		var cmd string
		fmt.Print(">")
		fmt.Scanln(&cmd)

		switch strings.ToLower(cmd) {
		case "print":
			var line30 = strings.Repeat("-", 30)
			fmt.Printf("|%-30s|%-30s|%-30s|\n", "Vorname", "Nachname", "Email")
			fmt.Printf("+%s+%s+%s+\n", line30, line30, line30)
			for _, p := range personen {
				fmt.Printf("|%-30s|%-30s|%5s|\n", p.Vorname, p.Nachname, p.Email)
			}
		case "add":
			var person Person
			inputPerson(&person)

			personen = append(personen, person)
		case "open":
			if p, err := open(filename); err != nil {
				log.Print(err)
			} else {
				personen = p
			}
		case "save":
			if err := save(filename, personen); err != nil {
				log.Print(err)
			}
		case "exit":
			fmt.Println("Bye!")
			return
		}
	}
}
